{ DEMO per a MUSIC.TPU V.4.01 }
{ Autor: Francesc Busquets }
{ Desembre 1989 }

program Demo;

  { Demostraci de l's de la unitat MUSIC.TPU per a Turbo Pascal.
    Aquest programa de demostraci utilitza els fitxers EUROPA.DMM i
    EUROPA.DMP, generats amb el programa MUSIC mitjanant les opcions
    d'exportaci a Turbo Pascal. Els fitxers DMM (Dades de Msica
    Monofnica) es generen si la modalitat d'execuci de MUSIC era "PC-MONO"
    en el moment d'executar l'exportaci. Els fitxers DMP (Dades de
    Msica Polifnica) es generen en la modalitat d'execuci "PC-POLI".}

uses dos,crt,music;

var Europa1:   Tonada;           { Europa1 contindr les dades monofniques }
    Europa2:   Polifonia;        { Europa2 contindr les dades polifniques }

    PunterN:   Polifonia;        { PunterN s utilizat per a l'execuci
                                   nota a nota en polifonia }

    i:        Integer;           { Altres variables del programa }
    ch:       Char;

begin

{ --------------------------------------------------------------------------
  INICIALITZACIO
  ------------------------------------------------------------------------- }

     { Crrega de les dades en Europa1 i Europa2. Cal que els fitxers
       DMM i DMP es trobin en el directori actiu en el moment d'executar
       el programa }

     Europa1:= Carrega_Tonada ('EUROPA.DMM');
     Europa2:= Carrega_Polifonia ('EUROPA.DMP');

              { Texts de presentaci }
              TextBackground(0); TextColor(2); ClrScr;
              WriteLn('---------------------------------------------------------');
              WriteLn('DEMOSTRACIO DE LA UNITAT MUSIC.TPU PER A TURBO-PASCAL 4/5');
              WriteLn('---------------------------------------------------------');


{ --------------------------------------------------------------------------
  EXECUCIO MONOFONICA EN BACKGROUND
  ------------------------------------------------------------------------- }

              { Texts de presentacin }
              TextBackground (0); TextColor (7); GotoXY (1,7);
              WriteLn ('Msica monofnica');
              WriteLn ('en "BackGround" ...');
              TextBackground (6); TextColor (0); Window (25,5,70,10);

     { Crida a l'execuci de Europa1 (monofnica), amb repetici }
     Toca_Tonada(Europa1);
     Repeticio:=True;

     { La variable "Nota" cont el nmero de nota que s'est executant }
     Repeat WriteLn (' Est sonant la nota ', Nota);
     until not Musica_Activa or KeyPressed;

              WriteLn (' Execuci interrompuda per l''usuari. ');
              Ch:= ReadKey;

     { Fi de l'execuci utilizant el procedimient "Calla"}
     Calla;


{ --------------------------------------------------------------------------
  EXECUCIO POLIFONICA
  ------------------------------------------------------------------------- }

              { Texto de presentaci }
              Window (1,1,79,25); TextBackground (0); TextColor (7);
              GotoXY (1,12); WriteLn ('Msica polifnica ...');

     { Crida a l'execuci d'"Europa2" (polifnica). L'execuci no s
       interrompible per l'usuari }
     Toca_Polifonia (Europa2);
     Calla;


{ --------------------------------------------------------------------------
  EXECUCIO POLIFONICA NOTA A NOTA
  ------------------------------------------------------------------------- }

              { Texts de presentaci }
              if KeyPressed then repeat Ch:= ReadKey until not KeyPressed;
              GotoXY (1,18);
              WriteLn ('Msica polifnica');
              WriteLn ('nota a nota ...');
              TextBackground (6); TextColor (0);
              Window (25,15,70,24);ClrScr;

     { "PunterN" apunta al primer bloc de notes en polifonia }
     PunterN:= Europa2;

     { Execuci d'"Europa2" nota a nota. PunterN es va actualitzant desprs
       de l'execuci de cada bloc, amb el registre ".Next". KeyPressed indica
       si l'usuari ha tocat alguna nota per a interrompre l'execuci. Si no
       es aix, acabar quan s'arribi a l'ltim bloc de notes, on ".Codi[1]"
       val zero }
     i:= 1;
     while (PunterN^.Codi[1]<>0) and (not KeyPressed) do
        begin
          WriteLn (' Est sonant la nota ',i);
          { Crida a "Polifon" per a executar el bloc de notes }
          Polifon (PunterN^.Codi);
          PunterN:= PunterN^.Next;
          Inc(i);
        end;
     Calla;


{ --------------------------------------------------------------------------
  FI DEL PROGRAMA
  ------------------------------------------------------------------------- }

              if KeyPressed then
                 begin
                   WriteLn (' Execuci interrompuda per l''usuari ... ');
                   Ch:= ReadKey;
                 end
              else
                 WriteLn (' Fi de l''execuci.');
              repeat until KeyPressed;
              TextBackground (0); TextColor (7); Window (1,1,79,25);
              ClrScr;

end.
