unit Music;

interface
uses crt,dos;

{$F+}
{$L Polifon}

type
    Tonada     = ^Element;
    Element    = record
                       Frequencia: integer;
                       Durada:     integer;
                       Next:       Tonada;
                 end;

    Codi_P     = array [1..64] of integer;
    Polifonia  = ^Element_P;
    Element_P  = record
                       Codi: Codi_P;
                       Next: Polifonia;
                 end;

var
   Nota:          integer;
   Repeticio:     boolean;
   Musica_Activa: boolean;


procedure Toca_Tonada(T: Tonada);
procedure Toca_Polifonia(P: Polifonia);

function  Carrega_Tonada(Nom_Fitxer: string):Tonada;
function  Carrega_Polifonia (Nom_Fitxer: string):Polifonia;

procedure Oblida_Tonada(T: Tonada);
procedure Oblida_Polifonia(P: Polifonia);

procedure Calla;

procedure Polifon(P: Codi_P);


implementation

var
   Vella_Interrupcio: pointer;
   Comptador:         integer;
   Comptador2:        integer;
   Tema,Punter:       Tonada;

procedure Polifon(P: Codi_P); external;
procedure AjustaT;            external;

procedure Calla;
begin
     if Musica_Activa then
        begin
             inline($FA);
             SetIntVec($1C,Vella_Interrupcio);
             Musica_Activa:=false;
             Nota:=0;
             inline($FB);
             NoSound;
        end;
end;

procedure Ajusta_Durada(D: integer);
begin
     Comptador := abs(D);
           if D < 0 then
              begin
                   Comptador2 := Comptador div 8;
                   if (Comptador2 < 1) and (Comptador > 1) then
                      Comptador2 := 1;
              end
           else
               Comptador2 := 0;
end;

procedure Interrupcio_28(flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP: word);
interrupt;
var
   freq: integer;
begin
   dec(Comptador);
   if Comptador = Comptador2 then sound(17000);
   if Comptador <= 0 then
      begin
           inc(Nota);
           Punter:=Punter^.next;
           Freq:=Punter^.Frequencia;
           case Freq of
                -1: NoSound;
                 0: if Repeticio then
                       begin
                            Punter:=Tema;
                            Sound(Punter^.Frequencia);
                            Nota:=1;
                       end
                    else
                        Calla;
                 else
                     sound(Freq);
                 end;
           Ajusta_Durada(Punter^.Durada);
      end;
end;

procedure Toca_Tonada(T: Tonada);
begin
     inline($FA);
     Tema:=T;
     Punter:=T;
     Repeticio:=false;
     Nota:=0;
     if Punter^.Frequencia <> 0 then
        begin
             nosound;
             Ajusta_Durada(Punter^.Durada);
             sound(Punter^.Frequencia);
             Nota:=1;
             if Not Musica_Activa then
                begin
                     GetIntVec($1C,Vella_Interrupcio);
                     SetIntVec($1C,@Interrupcio_28);
                     Musica_Activa:=true;
                end;
        end;
    inline($FB);
end;

function Carrega_Tonada(Nom_Fitxer: string):Tonada;
var
   Fitxer: file of integer;
   P:      Tonada;

begin
     assign(Fitxer,Nom_Fitxer);
     reset(Fitxer);
     new(P);
     Carrega_Tonada:=P;
     while not eof(Fitxer) do
           begin
                read(Fitxer,P^.Frequencia);
                read(Fitxer,P^.Durada);
                new(P^.Next);
                P:=P^.Next;
           end;
     close(Fitxer);
     P^.Frequencia:=0;
     P^.Durada:=0;
end;

function Carrega_Polifonia (Nom_Fitxer: string):Polifonia;
var
   Fitxer: file of integer;
   P:      Polifonia;
   Surt:   boolean;
   I:      integer;
begin
     Assign(Fitxer,Nom_Fitxer);
     reset(Fitxer);
     new(P);
     Carrega_Polifonia:=P;
     while not eof(Fitxer) do
           begin
                I:=1;
                Surt:=false;
                while (not Surt) do
                      begin
                           read(Fitxer,P^.Codi[I]);
                           if P^.Codi[I]=0 then Surt:=true;
                           inc (I);
                           if I>=64 then
                              begin
                                   Surt:=true;
                                   P^.Codi[I]:=0;
                              end;
                      end;
                new(P^.Next);
                P:=P^.Next;
           end;
     close (Fitxer);
     P^.Codi[1]:=0;
end;

procedure Toca_Polifonia(P: Polifonia);
begin
     if not Musica_Activa then
        begin
             while P^.Codi[1]<>0 do
                   begin
                        Polifon(P^.Codi);
                        P:=P^.next;
                   end;
             nosound;
        end;
end;

procedure Oblida_Polifonia(P: Polifonia);
var
   Q: Polifonia;
begin
     if not Musica_Activa then
        begin
             while P^.Codi[1]<>0 do
                   begin
                        Q:=P^.next;
                        Dispose(P);
                        P:=Q;
                   end;
             Dispose(P);
        end;
end;

Procedure Oblida_Tonada(T: Tonada);
var
   Q: Tonada;
begin
     if not Musica_Activa then
        begin
             while T^.Frequencia<>0 do
                   begin
                        Q:=T^.next;
                        Dispose(T);
                        T:=Q;
                   end;
             Dispose(T);
        end;
end;

begin
     Musica_Activa:=false;
     Nota:=0;
     Comptador := 0;
     Repeticio:=False;
     AjustaT;
end.

